<?php

$this->pageTitle = ''.Yii::app()->name.' - Edytuj egzamin w szkoleniu '.$model->nazwa;

$this->breadcrumbs = array(
	'Szkolenia'=>array('admin'),
	'Edytuj szkolenie '.$model->nazwa=>array('update','id'=>$model->id),
	'Edytuj egzamin w szkoleniu '.$model->nazwa,
);

?>
<h1>Edytuj egzamin w szkoleniu <?php echo $model->nazwa; ?></h1>

<?php 
	Yii::app()->clientScript->registerScript('game', <<<SCRIPT

       

SCRIPT
, CClientScript::POS_READY);
?>

<?php
$this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'szkolenie-grid',
	'htmlOptions' => array('class' => 'tDefault'),
	'dataProvider'=>new CActiveDataProvider('SzkoleniePytaniaEgzamin',array(
			'criteria'=>array(
				'condition'=>'"idSzkolenia"='.$model->id,
			)
	)),
	'columns'=>array(
		'tresc',
		array(
			'class'=>'CButtonColumn',
			'buttons'=>array(
			'update' => array(
				'label'=>'Edytuj',     // text label of the button
				'url'=>'Yii::app()->createUrl("/administration/szkolenie/updateQuestion", array("id"=>$data->id))',       // a PHP expression for generating the URL of the button
				//'visible'=>true,   // a PHP expression for determining whether the button is visible
			),
			'delete' => array(
				'label'=>'Usuń',     // text label of the button
				'url'=>'Yii::app()->createUrl("/administration/szkolenie/deleteQuestion", array("id"=>$data->id))',       // a PHP expression for generating the URL of the button
				//'visible'=>true,   // a PHP expression for determining whether the button is visible
			)),
			'template' => '{update} {delete}'
		)
	)
));
?>
<?php if(count($model->pytania) < 3): ?>
<a href="<?php echo $this->createUrl('/administration/szkolenie/generateQuestions', array('id'=>$model->id)) ?>" class="buttonS bGreen">Generuj brakujące pytania</a><br/>
<?php endif; ?>
<a href="<?php echo $this->createUrl('/administration/szkolenie/addQuestion',array('id'=>$model->id)) ?>">Dodaj pytanie</a>